<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:MSHelp="http://msdn.microsoft.com/mshelp">
	<xsl:strip-space elements="*"/>
	<xsl:preserve-space elements="SCRIPT"/>
	<xsl:output encoding="iso-8859-1" indent="yes"/>
	<xsl:key name="filekey" match="/files/file" use="translate(./text(),'ABCDEFGHIJKLMNOPQRSTUVWXYZ',
           'abcdefghijklmnopqrstuvwxyz')"/>
	<xsl:variable name="filelist" select="document('htmlfilelist.xml')"/>
	<xsl:template match="/files">
		<xsl:for-each select="file">
			<xsl:variable name="infilename" select="concat('uncleaned_html/',./text())"/>
			<xsl:variable name="outfilename" select="concat('html/',./text())"/>
			<xsl:for-each select="document($infilename)">
				<xsl:document href="{$outfilename}" method="xml" indent="yes">
					<xsl:apply-templates/>
				</xsl:document>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="html">
		<html>
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</html>
	</xsl:template>
	<xsl:template match="@* | node()">
		<xsl:copy>
			<xsl:apply-templates select="@* | node()"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="span[@class='linkList' and not(child::table)]">
		<xsl:variable name="templist">
			<xsl:apply-templates/>
		</xsl:variable>
		<xsl:if test="$templist/span/MSHelp:link">
			<span>
				<xsl:copy-of select="@*"/>
				<xsl:copy-of select="$templist"/>
			</span>
		</xsl:if>
	</xsl:template>
	<xsl:template match="span[@class='linkList' and child::table]">
		<xsl:variable name="templist">
			<xsl:apply-templates/>
		</xsl:variable>
		<xsl:if test="$templist/table">
			<span>
				<xsl:copy-of select="@*"/>
				<xsl:copy-of select="$templist"/>
			</span>
		</xsl:if>
	</xsl:template>
	<xsl:template match="span[@class='linkList']/table">
		<xsl:variable name="temptable">
			<table>
				<xsl:apply-templates/>
			</table>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="count($temptable/table/tr)>0">
				<xsl:copy-of select="$temptable"/>
			</xsl:when>
			<xsl:otherwise/>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="span[@class='linkList']/table/tr">
		<!-- this should only catch tables representing PME lists -->
		<xsl:variable name="tabledata">
			<xsl:for-each select="td[1]">
				<xsl:variable name="keywords" select="span/span/MSHelp:link/@keywords"/>
				<xsl:choose>
					<xsl:when test="not(starts-with($keywords,'System.'))">
						<xsl:variable name="noperiods">
							<xsl:if test="contains($keywords,' ')">
								<xsl:value-of select="substring-before(translate($keywords, '.', ''),' ')"/>
							</xsl:if>
							<xsl:if test="not(contains($keywords,' '))">
								<xsl:value-of select="translate($keywords, '.', '')"/>
							</xsl:if>
						</xsl:variable>
						<xsl:variable name="keyfound">
							<xsl:for-each select="$filelist">
								<xsl:value-of select="key('filekey', translate(concat($noperiods, 'method.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'property.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'event.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'class.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'interface.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'enum.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'type.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'variable.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'constant.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'routine.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'namespace.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'members.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))"/>
							</xsl:for-each>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$keyfound='false'">
								<!-- could print out a warning message here for undocumented members -->
							</xsl:when>
							<xsl:otherwise>
								<xsl:copy-of select="."/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:copy-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</xsl:variable>
		<xsl:if test="$tabledata/td">
			<xsl:copy-of select="."/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="span[@class='listedLink']">
		<xsl:for-each select="MSHelp:link">
			<xsl:variable name="keywords" select="./@keywords"/>
			<xsl:variable name="href" select="./@href"/>
			<xsl:choose>
				<xsl:when test="contains($keywords,'Borland')">
					<xsl:variable name="noperiods">
						<xsl:if test="contains($keywords,' ')">
							<xsl:value-of select="substring-before(translate($keywords, '.', ''),' ')"/>
						</xsl:if>
						<xsl:if test="not(contains($keywords,' '))">
							<xsl:value-of select="translate($keywords, '.', '')"/>
						</xsl:if>
					</xsl:variable>
					<xsl:variable name="keyfound">
						<xsl:for-each select="$filelist">
							<xsl:value-of select="key('filekey', translate(concat($noperiods, 'method.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'property.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'event.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'class.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'interface.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'enum.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'type.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'variable.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'constant.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'routine.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'namespace.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'members.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))"/>
						</xsl:for-each>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$keyfound='false'">
								<!-- could print out a warning message here for undocumented members -->
						</xsl:when>
						<xsl:otherwise>
							<span class="listedLink">
								<MSHelp:link>
									<xsl:copy-of select="@*"/>
									<xsl:copy-of select="node()"/>
								</MSHelp:link>
							</span>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<span class="listedLink">
						<MSHelp:link>
							<xsl:copy-of select="@*"/>
							<xsl:copy-of select="node()"/>
						</MSHelp:link>
					</span>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="MSHelp:link">
		<!-- remove link and containing text if not valid -->
		<!-- not yet checking whether it's the last link in a list -->
		<xsl:variable name="keywords" select="./@keywords"/>
		<xsl:choose>
			<xsl:when test="contains($keywords,'Borland')">
				<xsl:variable name="noperiods">
					<xsl:if test="contains($keywords,' ')">
						<xsl:value-of select="substring-before(translate($keywords, '.', ''),' ')"/>
					</xsl:if>
					<xsl:if test="not(contains($keywords,' '))">
						<xsl:value-of select="translate($keywords, '.', '')"/>
					</xsl:if>
				</xsl:variable>
				<xsl:variable name="keyfound">
					<xsl:for-each select="$filelist">
						<xsl:value-of select="key('filekey', translate(concat($noperiods, 'method.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'property.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'event.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'class.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'interface.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'enum.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'type.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'variable.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'constant.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'routine.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))
                                or key('filekey', translate(concat($noperiods, 'namespace.htm'),
                                'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))"/>
					</xsl:for-each>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="$keyfound='false'">
						<!-- could print out a warning message here for undocumented members -->
					</xsl:when>
					<xsl:otherwise>
						<MSHelp:link>
							<xsl:copy-of select="@*"/>
							<xsl:copy-of select="node()"/>
						</MSHelp:link>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<MSHelp:link>
					<xsl:copy-of select="@*"/>
					<xsl:copy-of select="node()"/>
				</MSHelp:link>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
